<?php 
include 'auth.php'; 
include 'config.php';

$id = $_GET['id'];
$msg = "";

// ডাটা আপডেট লজিক
if(isset($_POST['update'])){
    $ban_status = $_POST['ban_status'];
    $new_password = $_POST['password'];

    if(!empty($new_password)){
        // --- সমাধান এখানে ---
        // পাসওয়ার্ড প্লেইন টেক্সট না রেখে Hash করে সেভ করা হচ্ছে
        $final_pass = password_hash($new_password, PASSWORD_DEFAULT);

        $sql_update = "UPDATE users SET password='$final_pass', ban_status='$ban_status' WHERE id=$id";
    } else {
        // পাসওয়ার্ড বক্স খালি থাকলে শুধু স্ট্যাটাস আপডেট হবে
        $sql_update = "UPDATE users SET ban_status='$ban_status' WHERE id=$id";
    }
    
    if($conn->query($sql_update)){
        $msg = "<div class='alert alert-success border-0 shadow-sm text-center'>Changes Saved Successfully!</div>";
    } else {
        $msg = "<div class='alert alert-danger'>Error updating</div>";
    }
}

// ইউজার ডাটা আনা
$sql = "SELECT * FROM users WHERE id=$id";
$result = $conn->query($sql);
$row = $result->fetch_assoc();

$avatarLetter = strtoupper(substr($row['name'], 0, 1));
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit User Profile</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

    <style>
        body { background: #f3f4f6; font-family: 'Poppins', sans-serif; display: flex; align-items: center; justify-content: center; min-height: 100vh; }
        
        .profile-card {
            background: white; border-radius: 20px; box-shadow: 0 15px 40px rgba(0,0,0,0.05);
            width: 100%; max-width: 480px; overflow: hidden; border: none;
        }

        .card-header-bg {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            padding: 40px 20px 30px; text-align: center; color: white;
        }

        .avatar-circle {
            width: 80px; height: 80px; background: white; color: #00c6fb;
            border-radius: 50%; display: flex; align-items: center; justify-content: center;
            font-size: 32px; font-weight: bold; margin: 0 auto 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }

        .form-label { font-size: 13px; font-weight: 500; color: #888; margin-bottom: 5px; }
        
        .form-control[readonly] {
            background-color: #f8f9fa; border: 1px solid #eee; color: #555; cursor: not-allowed;
        }
        
        .form-control {
            border-radius: 10px; padding: 12px 15px; font-size: 14px; border: 1px solid #e0e0e0;
        }
        .form-control:focus { border-color: #4facfe; box-shadow: none; }

        .btn-save {
            background: linear-gradient(90deg, #4facfe 0%, #00f2fe 100%);
            border: none; padding: 12px; width: 100%; border-radius: 10px;
            font-weight: 600; color: white; margin-top: 15px; transition: 0.3s;
        }
        .btn-save:hover { transform: translateY(-2px); box-shadow: 0 8px 20px rgba(79, 172, 254, 0.4); }

        .btn-cancel {
            background: white; border: 1px solid #eee; color: #666; width: 100%;
            padding: 12px; border-radius: 10px; font-weight: 600; margin-top: 10px; transition: 0.3s;
        }
        .btn-cancel:hover { background: #f9f9f9; }
    </style>
</head>
<body>

    <div class="profile-card">
        
        <div class="card-header-bg">
            <div class="avatar-circle"><?php echo $avatarLetter; ?></div>
            <h4 class="mb-0 fw-bold"><?php echo $row['name']; ?></h4>
            <small class="opacity-75">Joined: <?php echo $row['res_date']; ?></small>
        </div>

        <div class="p-4">
            <?php echo $msg; ?>

            <form method="POST">
                
                <div class="mb-3">
                    <label class="form-label">Full Name (Read Only)</label>
                    <input type="text" class="form-control" value="<?php echo $row['name']; ?>" readonly>
                </div>

                <div class="mb-3">
                    <label class="form-label">Phone Number (Read Only)</label>
                    <input type="text" class="form-control" value="<?php echo $row['number']; ?>" readonly>
                </div>

                <!-- Password Section -->
                <div class="mb-3">
                    <label class="form-label text-primary">Password</label>
                    <input type="text" name="password" class="form-control border-primary" placeholder="Enter new password">
                    <small class="text-muted" style="font-size: 11px;">* Leave empty to keep current password.</small>
                </div>

                <!-- Status Section -->
                <div class="mb-4">
                    <label class="form-label">Account Status</label>
                    <select name="ban_status" class="form-select" style="border-radius: 10px;">
                        <option value="False" <?php if($row['ban_status'] == 'False' || $row['ban_status'] == 'false') echo 'selected'; ?>>✅ Active (Unbanned)</option>
                        <option value="True" <?php if($row['ban_status'] == 'True' || $row['ban_status'] == 'true') echo 'selected'; ?>>⛔ Banned (Restricted)</option>
                    </select>
                </div>

                <button type="submit" name="update" class="btn btn-save">
                    Save Changes
                </button>
                
                <a href="users.php" class="btn btn-cancel d-block text-center text-decoration-none">
                    Back to List
                </a>

            </form>
        </div>
    </div>

</body>
</html>