<?php
include 'auth.php'; 
include 'config.php'; 

// টাইমজোন সেট করা (বাংলাদেশ সময়)
date_default_timezone_set('Asia/Dhaka');

$msg = "";

// --- 1. DELETE NOTICE ---
if(isset($_GET['delete_id'])){
    $id = $_GET['delete_id'];
    $sql_del = "DELETE FROM notices WHERE id='$id'";
    if($conn->query($sql_del)){
        $msg = "<div class='alert alert-danger shadow-sm border-0'>Notice Deleted Successfully!</div>";
    } else {
        $msg = "<div class='alert alert-warning'>Error: " . $conn->error . "</div>";
    }
}

// --- 2. ADD NOTICE ---
if(isset($_POST['add_notice'])){
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $message = mysqli_real_escape_string($conn, $_POST['message']);
    
    // অটোমেটিক তারিখ ও সময় জেনারেট করা (আপনার অ্যাপের ফরম্যাট অনুযায়ী)
    // Format: hh:mm:ssa - dd/MM/yyyy
    $date = date('h:i:s a - d/m/Y'); 

    $sql = "INSERT INTO notices (title, message, date) VALUES ('$title', '$message', '$date')";
    
    if($conn->query($sql)){
        $msg = "<div class='alert alert-success shadow-sm border-0'>Notice Published Successfully!</div>";
    } else {
        $msg = "<div class='alert alert-warning'>Error: " . $conn->error . "</div>";
    }
}

// --- 3. FETCH NOTICES ---
$sql_show = "SELECT * FROM notices ORDER BY id DESC";
$result = $conn->query($sql_show);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>App Notices</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        body { background: #f0f2f5; font-family: 'Poppins', sans-serif; }
        
        /* Navbar */
        .custom-nav { background: #6c5ce7; padding: 15px 0; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        .navbar-brand { font-weight: 600; color: white !important; font-size: 1.2rem; }

        /* Left Side: Form Card */
        .form-card { background: white; border-radius: 15px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.05); padding: 25px; }
        .form-control { border-radius: 10px; padding: 12px; border: 1px solid #eee; background: #f9f9f9; }
        .form-control:focus { background: white; box-shadow: none; border-color: #6c5ce7; }
        
        .btn-publish { background: linear-gradient(135deg, #6c5ce7 0%, #a29bfe 100%); border: none; padding: 12px; width: 100%; border-radius: 10px; font-weight: 600; color: white; transition: 0.3s; }
        .btn-publish:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(108, 92, 231, 0.4); }

        /* Right Side: Notice List */
        .notice-item {
            background: white;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 15px;
            border-left: 5px solid #6c5ce7; /* Purple Accent */
            box-shadow: 0 3px 10px rgba(0,0,0,0.03);
            position: relative;
            transition: 0.3s;
        }
        .notice-item:hover { transform: translateX(5px); }
        
        .notice-title { font-weight: 600; color: #2d3436; font-size: 16px; margin-bottom: 5px; }
        .notice-msg { color: #636e72; font-size: 14px; line-height: 1.5; }
        .notice-date { font-size: 12px; color: #b2bec3; margin-top: 10px; display: block; }
        
        .btn-delete {
            position: absolute;
            top: 20px;
            right: 20px;
            color: #ff7675;
            background: #fff0f0;
            border: none;
            width: 35px;
            height: 35px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: 0.3s;
        }
        .btn-delete:hover { background: #ff7675; color: white; }

    </style>
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-dark custom-nav mb-4">
        <div class="container">
            <span class="navbar-brand"><i class="fas fa-bell me-2"></i>Notice Board</span>
            <a href="dashboard.php" class="btn btn-outline-light btn-sm rounded-pill px-3">Back Home</a>
        </div>
    </nav>

    <div class="container">
        <?php echo $msg; ?>

        <div class="row">
            
            <!-- Left Side: Add Notice Form -->
            <div class="col-lg-4 mb-4">
                <div class="form-card h-100">
                    <h5 class="mb-4 text-dark"><i class="fas fa-edit me-2 text-primary"></i>Write Notice</h5>
                    <form method="POST">
                        <div class="mb-3">
                            <label class="text-muted small mb-1 fw-bold">Notice Title</label>
                            <input type="text" name="title" class="form-control" placeholder=" " required>
                        </div>
                        
                        <div class="mb-4">
                            <label class="text-muted small mb-1 fw-bold">Message Body</label>
                            <textarea name="message" class="form-control" rows="5" placeholder="Write your full notice here..." required></textarea>
                        </div>

                        <button type="submit" name="add_notice" class="btn btn-publish">
                            <i class="fas fa-paper-plane me-2"></i> ADD NOTICE
                        </button>
                    </form>
                </div>
            </div>

            <!-- Right Side: Notice List -->
            <div class="col-lg-8">
                <h5 class="mb-3 ms-1 text-muted">All Published Notices</h5>
                
                <?php if($result->num_rows > 0) { 
                    while($row = $result->fetch_assoc()) { ?>
                    
                    <div class="notice-item">
                        <div class="notice-title"><?php echo $row['title']; ?></div>
                        <div class="notice-msg"><?php echo nl2br($row['message']); ?></div>
                        <span class="notice-date"><i class="far fa-clock me-1"></i> <?php echo $row['date']; ?></span>
                        
                        <!-- Delete Button -->
                        <a href="notice.php?delete_id=<?php echo $row['id']; ?>" class="btn-delete shadow-sm" onclick="return confirm('Are you sure you want to delete this notice?');">
                            <i class="fas fa-trash-alt"></i>
                        </a>
                    </div>

                <?php }} else { ?>
                    <div class="text-center p-5 text-muted">
                        <i class="far fa-folder-open fa-3x mb-3"></i><br>
                        No notices found. Add one from the left!
                    </div>
                <?php } ?>

            </div>

        </div>
    </div>
    <br><br>

</body>
</html>