<?php
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $number = $_POST['Number'];
    $password = $_POST['Password'];

    if (empty($number) || empty($password)) {
        echo "All fields are required";
    } else {
        $stmt = $conn->prepare("SELECT password FROM users WHERE number = ?");
        $stmt->bind_param("s", $number);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $stmt->bind_result($hashed_password);
            $stmt->fetch();

            if (password_verify($password, $hashed_password)) {
                echo "Login Successful";
            } else {
                echo "Invalid Password";
            }
        } else {
            echo "User not found";
        }
        $stmt->close();
    }

} else {
    echo "Invalid Request Method";
}

$conn->close();
?>