<?php
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $name = $_POST['Name'];
    $number = $_POST['Number'];
    $password = $_POST['Password'];
    $resDate = $_POST['ResDate'];

    if (empty($name) || empty($number) || empty($password) || empty($resDate)) {
        echo "All fields are required";
    } else {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        $checkQuery = "SELECT id FROM users WHERE number = ?";
        $stmt = $conn->prepare($checkQuery);
        $stmt->bind_param("s", $number);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            echo "Number already exists!";
        } else {
            $insertQuery = "INSERT INTO users (name, number, password, res_date) VALUES (?, ?, ?, ?)";
            $stmt = $conn->prepare($insertQuery);
            $stmt->bind_param("ssss", $name, $number, $hashed_password, $resDate);

            if ($stmt->execute()) {
                echo "Account Created Successfully";
            } else {
                echo "Failed to create account";
            }
        }
        $stmt->close();
    }

} else {
    echo "Invalid Request Method";
}

$conn->close();
?>